package gov.va.med.mhv.mrp.service.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskActivitiesDTO;
import gov.va.med.mhv.mrp.common.dto.MyTaskDTO;
import gov.va.med.mhv.mrp.data.model.MyGoalsTaskActivities;
import gov.va.med.mhv.mrp.data.model.MyGoalsTasks;

@Component
public class MyTaskConverter implements Converter<MyGoalsTasks, MyTaskDTO> {

	@Autowired
	private MyGoalsTaskActivitiesConverter myGoalsTaskActivitiesConverter;
	
	@Override
	public MyTaskDTO convert(MyGoalsTasks e) {
		MyTaskDTO dto = new MyTaskDTO();
		
		dto.setCompletedDate(e.getCompletedDate());
		dto.setCompletionType(e.getCompletionType());
		dto.setDescription(e.getDescription());
		dto.setEndDate(e.getEndDate());
		dto.setEndTime(e.getEndTime());
		dto.setGoalExtensionId(e.getMyGoalsExtension().getGoalExtensionId());
		dto.setTaskId(e.getTaskId());
		dto.setStartDate(e.getStartDate());
		dto.setStartTime(e.getStartTime());
		dto.setStatus(e.getStatus());
		dto.setTaskName(e.getTaskName());
		dto.setTaskRepetitionCycleType(e.getTaskRepetitionCycleType());
		dto.setTaskSequenceNumber(e.getTaskSequenceNumber());
		
		if (e.getMyGoalsTaskActivities() != null) {
			for (MyGoalsTaskActivities activity : e.getMyGoalsTaskActivities()) {
				MyGoalsTaskActivitiesDTO activityDTO = myGoalsTaskActivitiesConverter.convert(activity);
				dto.getMyGoalsTaskActivities().add(activityDTO);
			}
		}
		
		return dto;
	}

}
